//////////////////////////////////////////////////////////////////////////////////////////

#define _Yes_     0x01
#define _No_      0x02
#define _Error_   0x03
#define _Success_ 0x04

//////////////////////////////////////////////////////////////////////////////////////////

// *** User Functions
short xCommandService(char *, DWORD);
short xIsServiceInstalled(char *);
short xInstallService(char *, char *, char *);
short xUninstallService(char *);
short xStartService(char *);
short xTriggerEvent(char *);

//////////////////////////////////////////////////////////////////////////////////////////

#define ServiceEventName       "ServiceEventName"
#define OpenDialogEventName    "OpenDialogEventName"

//////////////////////////////////////////////////////////////////////////////////////////
/*
SERVICE_CONTROL_STOP
    Requests the service to stop. The hService handle must have SERVICE_STOP access.
SERVICE_CONTROL_PAUSE
    Requests the service to pause. The hService handle must have SERVICE_PAUSE_CONTINUE access.
SERVICE_CONTROL_CONTINUE
    Requests the paused service to resume. The hService handle must have SERVICE_PAUSE_CONTINUE access.
SERVICE_CONTROL_INTERROGATE
    Requests the service to update immediately its current status information to the service control manager. The hService handle must have SERVICE_INTERROGATE access.
SERVICE_CONTROL_SHUTDOWN
    The ControlService function fails if this control code is specified.
*/

short xCommandService(char *ServiceName, DWORD xCommand)
{
    SERVICE_STATUS ServiceStatus;
	SC_HANDLE ServiceControlHandle = NULL;
	SC_HANDLE ServiceHandle        = NULL;

    BOOL Result = FALSE;

	// UnInstall The Service From Service Control Manager Database
	ServiceControlHandle = OpenSCManager( NULL, NULL, SC_MANAGER_CREATE_SERVICE );
	if( ServiceControlHandle == NULL )
	{
		MessageBox( NULL, "Error in xStartService-OpenSCManager !", TitleCaption, MB_ICONERROR );
		return _Error_;
	}

	ServiceHandle = OpenService( ServiceControlHandle, ServiceName, SERVICE_ALL_ACCESS  );

	if( ServiceHandle == NULL )
	{
		MessageBox( NULL, "Error in xStartService-OpenService !", TitleCaption, MB_ICONERROR );
        CloseHandle(ServiceHandle);
        CloseHandle(ServiceControlHandle);
		return _Error_;
	}

    Result = ControlService(
        ServiceHandle,
        xCommand,
        &ServiceStatus 
    );

    if(Result == FALSE)
    {
		MessageBox( NULL, "Error in xCommandService-ControlService !", TitleCaption, MB_ICONERROR );
        CloseHandle(ServiceHandle);
        CloseHandle(ServiceControlHandle);
        return _Error_;
    }

    CloseHandle(ServiceHandle);
    CloseHandle(ServiceControlHandle);

    return _Success_;

}

//////////////////////////////////////////////////////////////////////////////////////////

short xStartService(char *ServiceName)
{
	SC_HANDLE ServiceControlHandle = NULL;
	SC_HANDLE ServiceHandle = NULL;
    BOOL Result = FALSE;

	// UnInstall The Service From Service Control Manager Database
	ServiceControlHandle = OpenSCManager( NULL, NULL, SC_MANAGER_CREATE_SERVICE );
	if( ServiceControlHandle == NULL )
	{
		MessageBox( NULL, "Error in xStartService-OpenSCManager !", TitleCaption, MB_ICONERROR );
		return _Error_;
	}

	ServiceHandle = OpenService( ServiceControlHandle, ServiceName, SERVICE_ALL_ACCESS  );

	if( ServiceHandle == NULL )
	{
		MessageBox( NULL, "Error in xStartService-OpenService !", TitleCaption, MB_ICONERROR );
        CloseHandle(ServiceHandle);
        CloseHandle(ServiceControlHandle);
		return _Error_;
	}

    Result = StartService(
        ServiceHandle,	// Handle Of Service
        NULL,	        // Number Of Arguments
        NULL            // Address Of Array Of Argument String Pointers
    );

    if(Result == FALSE)
    {
		MessageBox( NULL, "Error in xStartService-StartService !", TitleCaption, MB_ICONERROR );
        CloseHandle(ServiceHandle);
        CloseHandle(ServiceControlHandle);
        return _Error_;
    }

    CloseHandle(ServiceHandle);
    CloseHandle(ServiceControlHandle);

    return _Success_;
}

//////////////////////////////////////////////////////////////////////////////////////////

short xInstallService(char *ServiceName, char *DisplayName, char *Application)
{
	SC_HANDLE ServiceControlHandle;
	SC_HANDLE ServiceHandle;

	// Install the Service In The Control Manager Database
	ServiceControlHandle = OpenSCManager( NULL, NULL, SC_MANAGER_CREATE_SERVICE );
	if( ServiceControlHandle == NULL )
	{
		MessageBox( NULL, "Error in xInstallService-OpenSCManager !", TitleCaption, MB_ICONERROR );
		return _Error_;
	}

	ServiceHandle = CreateService(
        ServiceControlHandle,
		ServiceName,
		DisplayName,
		SERVICE_ALL_ACCESS,
		SERVICE_WIN32_OWN_PROCESS | SERVICE_INTERACTIVE_PROCESS,
		SERVICE_AUTO_START,
		SERVICE_ERROR_NORMAL,
		Application,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL );

	if( ServiceHandle == NULL )
	{
		MessageBox( NULL, "Error in xInstallService-CreateService !", TitleCaption, MB_ICONERROR );
		CloseHandle( ServiceControlHandle );
		return _Error_;
	}

    CloseHandle( ServiceHandle );
	CloseHandle( ServiceControlHandle );

	return _Success_;
}

//////////////////////////////////////////////////////////////////////////////////////////

short xUninstallService(char *ServiceName)
{

	SC_HANDLE ServiceControlHandle;
	SC_HANDLE ServiceHandle;

	// UnInstall The Service From Service Control Manager Database
	ServiceControlHandle = OpenSCManager( NULL, NULL, SC_MANAGER_CREATE_SERVICE );
	if( ServiceControlHandle == NULL )
	{
		MessageBox( NULL, "Error in xUninstallService-OpenSCManager !", TitleCaption, MB_ICONERROR );
		return _Error_;
	}

	ServiceHandle = OpenService( ServiceControlHandle, ServiceName, SERVICE_ALL_ACCESS  );

	if( ServiceHandle == NULL )
	{
		MessageBox( NULL, "Error in xUninstallService-OpenService !", TitleCaption, MB_ICONERROR );
		CloseHandle(ServiceHandle);
	    CloseHandle(ServiceControlHandle);
		return _Error_;
	}

	if( !DeleteService(ServiceHandle) )
	{
		MessageBox( NULL, "Error in xUninstallService-DeleteService !", TitleCaption, MB_ICONERROR );
		return _Error_;
	}

	CloseHandle(ServiceHandle);
	CloseHandle(ServiceControlHandle);

	return _Success_;
}

//////////////////////////////////////////////////////////////////////////////////////////

short xIsServiceInstalled(char *ServiceName)
{

	SC_HANDLE ServiceControlHandle;
	SC_HANDLE ServiceHandle;

	ServiceControlHandle = OpenSCManager( NULL,  NULL, SC_MANAGER_CREATE_SERVICE );
	if( ServiceControlHandle == NULL )
	{
		MessageBox( NULL, "Error in xIsServiceInstalled-DeleteService !", TitleCaption, MB_ICONERROR );
		return _Error_;
	}

	ServiceHandle = OpenService( ServiceControlHandle, ServiceName, SERVICE_ALL_ACCESS  );

	if( ServiceHandle == NULL)
	{
        CloseHandle( ServiceHandle );
        CloseHandle( ServiceControlHandle );
		return _No_;
	}

	CloseHandle( ServiceHandle );
	CloseHandle( ServiceControlHandle );

	return _Yes_;
}

//////////////////////////////////////////////////////////////////////////////////////////

short xTriggerEvent(char *xxEventName)
{
	HANDLE LocalEventHandle = NULL;

	LocalEventHandle = OpenEvent(EVENT_MODIFY_STATE, FALSE, OpenDialogEventName );

  	if(!LocalEventHandle)
        return _Error_;

    if(!SetEvent(LocalEventHandle))
        return _Error_;

	return _Success_;
}

//////////////////////////////////////////////////////////////////////////////////////////

